Attribute VB_Name = "modRecTest"
'///////////////////////////////////////////////////////////////
' modRecTest.bas - Copyright (c) 2002-2003
'                        JOBnik! [Arthur Aminov, ISRAEL]
'                        e-mail: jobnik2k@hotmail.com
'
' BASS Recording example
' Originally Translated from: - rectest.c - Example of Ian Luck
'
' Uses: Pure API! Types and Functions are Included as well!
'///////////////////////////////////////////////////////////////

'Encoder command-lines and output files
Public Commands(1) As String
Public Files(1) As String

Public Declare Function MessageBox Lib "user32" Alias "MessageBoxA" (ByVal hwnd As Long, ByVal lpText As String, ByVal lpCaption As String, ByVal wType As Long) As Long

Public input_ As Long       'current input source
Public encoder As Long      'current encoder

Public chan As Long         'playback channel
Public RECORDCHAN As Long   'recording channel

Public Function RecordingCallback(ByVal handle As Long, ByVal buffer As Long, ByVal length As Long, ByVal user As Long) As Integer
    RecordingCallback = BASSTRUE ' continue recording if encoder is alive
End Function

'update the recording/playback counter
Public Sub UpdateDisplay()
    If RECORDCHAN <> 0 Then ' recording/encoding
        frmRecTest.txtVR.Text = BASS_ChannelGetPosition(RECORDCHAN)
    ElseIf chan <> 0 Then
        If BASS_ChannelIsActive(chan) <> 0 Then ' playing
            frmRecTest.txtVR.Text = BASS_ChannelGetPosition(chan) & " / " & BASS_StreamGetLength(chan)
        Else
            frmRecTest.txtVR.Text = BASS_StreamGetLength(chan)
        End If
    End If
End Sub

'start recording
Public Sub StartRecording()
    'Free old recording
    If chan <> 0 Then
        Call BASS_StreamFree(chan)
        chan = 0
        frmRecTest.btnPlay.Enabled = False
    End If
    
    'Start recording @ 44100hz 16-bit stereo (paused to add encoder first)
    RECORDCHAN = BASS_RecordStart(44100, BASS_RECORD_PAUSE, AddressOf RecordingCallback, 0)
    
    If (RECORDCHAN <> 0) Then
        'Get selected encoder (0=OGG, 1=MP3)
        If frmRecTest.Option1.value = True Then
            encoder = 0
        Else
            encoder = 1
        End If
        
        If BASS_Encode_Start(RECORDCHAN, Commands(encoder), 0, 0, 0) = 0 Then
            BASS_ChannelStop (RECORDCHAN)
            Call MessageBox(frmRecTest.hwnd, "Couldn't start encoding..." & vbCrLf & _
                "Make sure OGGENC.EXE (if encoding to OGG) is in the same" & vbCrLf & _
                "direcory as this RECTEST, or LAME.EXE (if encoding to MP3).", "Recording...", vbCritical)
        Else
            Call BASS_ChannelResume(RECORDCHAN)
            frmRecTest.tmrRecTest.Enabled = True
            frmRecTest.btnRecord.Caption = "Stop"
            frmRecTest.Option1.Enabled = False
            frmRecTest.Option2.Enabled = False
        End If
    Else
        Call MessageBox(frmRecTest.hwnd, "Error: Couldn't start recording", "Recording...", vbCritical)
    End If
End Sub

'stop recording
Public Sub StopRecording()
    Call BASS_Encode_Stop(RECORDCHAN)
    Call BASS_ChannelStop(RECORDCHAN)
    RECORDCHAN = 0
    
    'Create a stream from the recording
    chan = BASS_StreamCreateFile(False, Files(encoder), 0, 0, 0)
    If chan <> 0 Then
        frmRecTest.btnPlay.Enabled = True   'enable "play" button
        frmRecTest.btnRecord.Caption = "Record"
        frmRecTest.Option1.Enabled = True
        frmRecTest.Option2.Enabled = True
    End If
End Sub

Public Sub UpdateInputInfo()
    Dim it As Long
    it = BASS_RecordGetInput(input_)  ' get info on the input
   ' frmRecTest.sldInputLevel.value = GetLoWord(it)  'set the level slider
    
    Dim type_ As String
    Select Case (it And BASS_INPUT_TYPE_MASK)
        Case BASS_INPUT_TYPE_DIGITAL:
            type_ = "digital"
        Case BASS_INPUT_TYPE_LINE:
            type_ = "line-in"
        Case BASS_INPUT_TYPE_MIC:
            type_ = "microphone"
        Case BASS_INPUT_TYPE_SYNTH:
            type_ = "midi synth"
        Case BASS_INPUT_TYPE_CD:
            type_ = "analog cd"
        Case BASS_INPUT_TYPE_PHONE:
            type_ = "telephone"
        Case BASS_INPUT_TYPE_SPEAKER:
            type_ = "pc speaker"
        Case BASS_INPUT_TYPE_WAVE:
            type_ = "wave/pcm"
        Case BASS_INPUT_TYPE_AUX:
            type_ = "aux"
        Case BASS_INPUT_TYPE_ANALOG:
            type_ = "analog"
        Case Else:
            type_ = "undefined"
    End Select
    frmRecTest.lblInputType.Caption = type_ 'display the type
End Sub
